/******************************************************************************
* (C) Copyright 2002 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include "AgtError.h"

CAgtException::CAgtException( const char* errmsg, const char *file, UInt32 line )
{
  if( errmsg == NULL )
    errmsg = "Unknown error";

  myerrmsg = ( char* )new char[strlen( errmsg ) + strlen( file ) + 35];

  // work around the problem that the first 8 characters are broken
  sprintf(myerrmsg,"        %s (File: %s Line: %lu)", errmsg, file, line );
}

CAgtException::~CAgtException( void )
{
  delete [] myerrmsg;
  myerrmsg = NULL;
}

const char * CAgtException::what() const
{
  // work around the problem that the first 8 characters are broken.. 
  return myerrmsg + 8;
}

AGTPCIPORT_API std::ostream& operator << (std::ostream& os, const CAgtException& e)
{
  os << e.what();
  return os;
}